## Create Incident File

1. Create a new incident file at <Incident File Location> using the [incident name](#name-the-incident).  Use this file for secure storage of documentation, evidence, artifacts, _etc._
    * Provision secure digital storage.
    * Provision secure file exchange.
    * Obtain physical storage.
    * Share the incident file location on the call and chat.
    * `TODO: Customize and automate file location and procedure`
1. Document the functional and information impact, if known (see [Assess]()). `TODO: Customize impact categories, if necessary.`
1. Document the vector, if known (_e.g.,_ web, email, removable media). `TODO: Customize vector list, if necessary.`
1. Document the incident summary: a brief overview of the vector, impact, investigation, and remediation situation, if known.
1. Document the incident timeline, including attacker activity and responder activity. `TODO: Add timelines of varying details, as necessary.`
1. Document investigation, remediation, and communication steps.  Document activities independently so they can be combined and reused, if possible.
1. Track significant information such as:
    * **Evidence**, with time of collection, source, chain of custody, _etc._
    * **Affected systems**, with how and when system was identified, and summary of effect (_e.g._, has malware, data accessed).
    * **Files of interest**, such as malware or data files, with system and metadata.
    * **Accessed and taken data**, with filenames, metadata, and time of suspected exposure.
    * **Significant attacker activity**, such as logins and malware execution, with time of the event.
    * **Network-based indicators of compromise (IOCs)**, such as IP addresses and domains.
    * **Host-based IOCs**, such as filenames, hashes, and registry keys.
    * **Compromised accounts**, with scope of access and time of compromise.

`TODO: Customize incident documentation procedure, including spreadsheets, databases, forms, systems, and templates, if necessary.`
